s        f   b &  ?@                                     SNSGI                           Sorensen SGI                                                                                            ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]     
 
ViConstString      This instrument module provides programming support for the Sorensen SGA.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
         This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

         Output State         This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

() Function Name:
This function ...        This class contains high-level routines for creating and executing sequences.

Fifty Sequences by Twenty steps each can be defined and programmed. Program commands include Calls to other sequences, Return, Loop, Goto other sequences, Repeat, Next, Pause, Resume and Stop.

A sequence can be selcted, defined and then saved. Once saved the sequence can not be edited and must be re-defined if a change is desired.         This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions/SubClasses:

() Function Name:
This function ...    W    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.
        Sorensen SGA Power Supplies with an Remote Programming Interface option.

This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state and clears all error and status information.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
    q    This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
            
The GPIB keyword is used with GPIB instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    D    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 

    , =         Resource Name                      :        ID Query                           =        Reset Device                           }    Instrument Handle                 W       Status                             
"GPIB::1"   Yes VI_ON No VI_OFF   Yes VI_ON No VI_OFF    	           	           {    This function configures and initiates the power supply to generate a DC voltage.

SCPI: SOURCE[]:VOLTAGE <voltage value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
              Instrument Handle                 t        Status                             3        Voltage                                	           0.0    {    This function configures and initiates the power supply to generate a DC current.

SCPI: SOURCE[]:CURRENT <current value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     {    Pass the DC current you want the power supply to generate.
Units: ampheres

Valid Range: dependent upon the model in use
              Instrument Handle                 V        Status                             3        Current                                	           0.0    z    This function configures and initiates the power supply to generate a power setting.

SCPI: SOURCE[]:POWER <power value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
               Instrument Handle                 !:        Status                            ! 3        Power                                  	           0.0   D    This function configures and initiates the power supply to generate a DC voltage ramp starting from the present output voltage and ending at the specified voltage in the specified time. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:VOLTAGE:RAMP <ending voltage value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     -    Ramp time in seconds.
Valid range 0.1 - 99.    $=          Instrument Handle                 $        Status                            %f 3        Voltage                           % 3       Time                                   	           0.0    0.0   D    This function configures and initiates the power supply to generate a DC current ramp starting from the present output current and ending at the specified current in the specified time. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:CURRENT:RAMP <ending current value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      x    Pass the DC current you want the power supply to generate.
Units: amps

Valid Range: dependent upon the model in use

     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    (X          Instrument Handle                 )         Status                            ) =        Current                           * @        Time                                   	           0.0    0.0        This function sets the output state to On (1) or Off (0). If set to OFF the Voltage and Current values will be set to zero. If set to ON the Voltage and Current will be set to their last programmed values.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     ,  4        Instrument Handle                 ,       Status                           aL        State                                  	            On 1 Off 0    T    This function takes a voltage measurement of the output.

SCPI: MEASURE[]:VOLTAGE?     +    Returns the measured value.

Units: volts         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     .D 3        Voltage Measurement               .w  	        Instrument Handle                 /        Status                             	               	           T    This function takes a current measurement of the output.

SCPI: MEASURE[]:CURRENT?     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     0 3        Current Measurement               0  	        Instrument Handle                 1        Status                             	               	           P    This function takes a power measurement of the output.

SCPI: MEASURE[]:POWer?     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     3, 3        Power Measurement                 3c  	        Instrument Handle                 4        Status                             	               	               This function returns the operationing mode of the power supply. The two modes of operation are constant voltage (mode = 0) and constant current (mode = 1). See Protection Condition Status Register for more information.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     6-  /        Instrument Handle                 6 H      status                           [C       Mode                               0    	            	               The power supply has two modes of operation: constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant voltage mode to constant current mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     9  /        Instrument Handle                 :C H      status                           Sy        Service Request                    0    	            On 1 Off 0       The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant current mode to constant voltage mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     =  /        Instrument Handle                 = H      status                           Tx        Service Request                    0    	            On 1 Off 0        The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to operate in both modes. All Protection Event Status reporting mechanisms will be turned off.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     ?  2        Instrument Handle                 @ K      status                             0    	                This function configures the power supply to generate a triggered DC voltage . A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:VOLTAGE:TRIG <voltage value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    B>          Instrument Handle                 B        Status                            Ch 3        Voltage                                	           0.0        This function configures the power supply to generate a triggered DC current. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:CURRENT:TRIG <current value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
    E\          Instrument Handle                 F        Status                            F 3        Current                                	           0.0   2    This function configures the power supply to generate a triggered DC voltage ramp starting at the present output voltage and ending at the specified voltage in the specified time. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:VOLTAGE:RAMP:TRIG <voltage value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    H          Instrument Handle                 I        Status                            J 6        Voltage                           J 6        Time                                   	           0.0    0.0   2    This function configures the power supply to generate a triggered DC current ramp starting at the present output current and ending at the specified current in the specified time. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:CURRENT:RAMP:TRIG <current value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    L          Instrument Handle                 M        Status                            N' ?        Current                           N >        Time                                   	           0.0    0.0        This function sets the Over Voltage Protection limit. If the output of the instrument exceeds this value the instrument will shutdown and must be Reset to continue.

SCPI: SOURCE[]:VOLTAGE:PROTECTION <ovp value>
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          Pass the DC over voltage value you want the power supply shutdown at.
Units: volts
Valid Range: dependent upon the model in use

    P          Instrument Handle                 QS        Status                            Q 3        Overvoltage Protection                 	           0.0        This function sets the soft voltage and current programming limits.

SCPI: SOURCE[]:VOLTAGE:LIMIT <voltage value>
      SOURCE[]:CURRENT:LIMIT <current value>     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    S        Status                            T@          Instrument Handle                j        Volltage Limit                   n        Current Limit                      	               0.0    0.0        This function sets the power on output values for voltage, current, and over voltage protection.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE <voltage value>
      CALIBRATE[]:INITIAL:CURRENT <current value>
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION <ovp value>     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    V        Status                            Wd          Instrument Handle                _        Voltage                          W        Current                                  OVP                                	               0.0    0.0    0.0       This routine configures foldback mode. The three mode are: 0 = off, 1 = Constant Volatge, 2 = Constant Current. Configuring the foldback mode for Constant Voltage or Constant Current will cause the power supply to shut down if the other mode becomes active.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.    bi       Mode                              ZE  0        Instrument Handle                 Z h      Status                             0        	               Sets the programmable time delay that is executed by the supply before reporting output protection conditions after a new output voltage or current value is specified. Range is from 0 to 32 seconds.     $    Time Delay value, 0 to 32 seconds.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     \ bi       Delay                             ]  0        Instrument Handle                 ] h      Status                             0        	               This routine configures the number of voltage measurements to be average upon recept of a measure output voltage command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.     0    Number of voltage measurements to be averaged.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     _ bi       Average                           `2  0        Instrument Handle                 ` h      Status                             1        	               This routine configures the number of current measurements to be average upon recept of a measure output current command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.     0    Number of current measurements to be averaged.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     c
 bi       Average                           cE  0        Instrument Handle                 c h      Status                             1        	          b    This routine configures the Protection Event Status Enable Register which causes the instrument to shut down if Constant Current, Constant Voltage, Foldback Modes or other conditions are enabled. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: STATUS[]:PROTECTION:ENABLE <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     f          Instrument Handle                 g5 N      Status                           HO        Protection Event Enable                	           0        This routine configures the Standard Event Status Enable Register. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: *ESE[] <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     i@          Instrument Handle                 i N      Status                           HO        Standard Event Enable                  	           0   n    This routine sets the Service Request Enable Register which is used to enable GPIB Service Requests when a enabled protection event or standard event has occured. This register along with the Protection Event Status Enable Register or the Standard Event Status Enable Register must be programmed to enable generation of GPIB Service Requests.

SCPI: *SRE[] <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     l          Instrument Handle                 m< >      Status                           :B        Service Request Enable                 	           0    L    This function returns the programmed voltage value.

SCPI: SOURCE[]:VOLT?
     -    Returns the measured value.

Units:  volts
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     n 3        Programmed Voltage                n  	        Instrument Handle                 o        Status                             	               	           O    This function returns the programmed current value.

SCPI: SOURCE[]:CURRENT?
     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     q7 3        Programmed Current                qn  	        Instrument Handle                 r        Status                             	               	           O    This function returns the programmed current value.

SCPI: SOURCE[]:CURRENT?
     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     s 3        Programmed Power                  s  	        Instrument Handle                 t        Status                             	               	           h    This function returns the programmed overvoltage protection value.

SCPI: SOURCE[]:VOLTAGE:PROTECTION?     /    Returns the programmed value.

Units:  volts
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     v6 3        Programmed OVP                    vm  	        Instrument Handle                 w        Status                             	               	           :    This function gets the output state - On (1) or Off (0).         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     x  4        Instrument Handle                 y<       Status                           _       State                                  	            	                This function recalls the soft voltage and current programming limits.

SCPI: SOURCE[]:VOLTAGE:LIMIT?
      SOURCE[]:CURRENT:LIMIT?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     {  	        Instrument Handle                 {       Status                           O        Voltage Limit                    Q        Current Limit                          	           	           	               This function recalls the power on output voltage, current, and ovp values.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE?
      CALIBRATE[]:INITIAL:CURRENT?
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     }          Instrument Handle                 ~        Status                           6        Voltage                          4        Current                                  OVP                                    	           	           	           	           b    This function recalls the protection condition reporting delay .

SCPI: OUTPUT:PROTECTION:DELAY?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      #    Protection condition delay value.              Instrument Handle                 o        Status                             3        Delay                                  	           	               This function recalls the number of voltage reading that will be averaged upon receipt of a voltage measurent command.

SCPI: MEASURE:VOLTAGE:AVERAGE?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      7    The number of voltage readings that will be averaged.    w          Instrument Handle                         Status                             3        Average                                	           	                This function recalls the number of current reading that will be averaged upon receipt of a current measurent command.

SCPI: MEASURE:CURRENT:AVERAGE?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      7    The number of current readings that will be averaged.    ;          Instrument Handle                         Status                            e 3        Average                                	           	                This routine checks to see if system has finished its power-on initalization to be able to work with sequences.  The query returns 1 until the system finishes at which point 0 is returned.


SCPI: PROGram:INITializing
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      9    Contains the state for using sequencing after power-on.    C  F        Instrument Handle                  	      Status                            m  I       initialized                            	           0    V    This routine returns the names of all the defined sequences.

SCPI: PROGram:CATalog?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control returns the names of all the defined sequences.

Notes:

(1) The array must contain at least 256 elements ViChar[256].      d        Instrument Handle                 h '      Status                             w a       Catalog                                	           	                This routine sets up the selected sequence for triggered operation. See the Trigger Sequence command.

SCPI: PROGram:SELected:ARM         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.       F        Instrument Handle                 e 	      Status                                 	          *    This routine programs the selected step for Voltage or Current Mode operation at the defined Voltage, Current, and OVP values for the specified time. The mode of the power supply is settings and load dependent.

SCPI: PROGram:SELected:Define <step #> <VIMODE> <voltage> <current> <ovp> <duration>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     ?    This control contains the output voltage setting of the step.     @    This control contains the output current setting for the step.     I    This control contains the Over Voltage Protection setting for the step.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.     2        Instrument Handle                 ; '      Status                             ( 1       Step                               h 2       Voltage                           K h        Current                            h       OVP                                 2       Time                                   	           1    0    0    0    0   B    This routine programs the selected step for a Voltage Ramp at the defined Voltage, Current, and OVP values for the specified time. The voltage will ramp from the present voltage setting to the value programmed in the voltage control.

SCPI: PROGram:SELected:Define <step #> <RAMPTOV> <voltage> <current> <ovp> <duration>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     F    This control contains the ending output voltage setting of the step.     @    This control contains the output current setting for the step.     I    This control contains the Over Voltage Protection setting for the step.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.    . 2        Instrument Handle                  '      Status                            X ( 1       Step                               h 2       Voltage                            h        Current                           5 h       OVP                                 2       Time                                   	           1    0    0    0    0   ~    This routine programs the selected step for a Current Ramp at the defined Voltage, Current, and OVP values for the specified time. The current will ramp from the present current setting to the value programmed in the current control. An appropriate load is required for current mode operation.

SCPI: PROGram:SELected:Define <step #> <RAMPTOC> <voltage> <current> <ovp> <duration>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     ?    This control contains the output voltage setting of the step.     G    This control contains the ending output current setting for the step.     I    This control contains the Over Voltage Protection setting for the step.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.     2        Instrument Handle                  '      Status                            6 ( 1       Step                              } h 2       Voltage                            h        Current                            h       OVP                               d  2       Time                                   	           1    0    0    0    0       This routine programs the selected step for a Constant Power at the defined Voltage, Current, and OVP values for the specified time. If the specified power setting can not be realized then the power supply output will be limited to the voltage or current setting. These conditions are load dependent.

SCPI: PROGram:SELected:Define <step #> <POWERSETTINGS> <power> <voltage> <current> <ovp> <duration>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     H    This control contains the Maximum output voltage setting of the step.      H    This control contains the Maximum output current setting for the step.     I    This control contains the Over Voltage Protection setting for the step.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.     =    This control contains the output power setting of the step.     2        Instrument Handle                  }      Status                            ) ( 1       Step                              p  2       Voltage                                    Current                                   OVP                               a  2       Time                               X 3       Power                                  	           1    0    0    0    0    0        This routine programs the defined sequence to repeat continuously until a Pause or Stop command is issued..

SCPI: PROGram:SELected:Define <step #> <REPEAT>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.             Instrument Handle                 . 6      Status                             g         Step                                   	           1        This routine programs the presently defined sequence to begin execution of the specified sequence. See the Sequence Return command.

SCPI: PROGram:SELected:Define <step #> <SUBCALL> <seq. name>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     (    This control contains a sequence name.    v         Instrument Handle                  6      Status                             g         Step                                        Sequence                               	           1    0        This routine returns sequence execution to the next step of the calling sequence in which the Call command was defined.

SCPI: PROGram:SELected:Define <step #> <RETURN>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.             Instrument Handle                 _ 6      Status                             g         Step                                   	           1        This routine programs a sequence loop command. The set of sequence steps between the Loop command and the following Next command will be repeditively executed for the count specified.

SCPI: PROGram:SELected:Define <step #> <LOOP> <count>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     A    Thic control contains the loop count. Valid range is 1 - 65535.             Instrument Handle                 | 6      Status                             g         Step                              E          Loop                                   	           1    1    z    This routine programs a sequence next command. See Sequence Loop command.

SCPI: PROGram:SELected:Define <step #> <NEXT>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.             Instrument Handle                  6      Status                            ( g         Step                                   	           1    ~    This routine programs a sequence stop command which halts sequence execution.

SCPI: PROGram:SELected:Define <step #> <STOP>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.             Instrument Handle                 Q 6      Status                             g         Step                                   	           1        This routine programs a sequence goto command. Sequence execution will begin at the specified Sequence Name.

SCPI: PROGram:SELected:Define <step #> <GOTO> <sequence_name>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.     (    This control contains a Sequence Name.     %        Instrument Handle                 + 6      Status                             ] %       Step                                %       Sequence                               	           1    0        This routine programs a sequence pause command which will stop sequence execution until a Sequence Resume command is sent.

SCPI: PROGram:SELected:Define <step #> <PAUSE>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.             Instrument Handle                 n 6      Status                             g         Step                                   	           1         This routine programs a sequence NOP command which will  
 have no effect on the sequence. The sequence will continue onto the nex step.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.    ~         Instrument Handle                 & 6      Status                             g         Step                                   	           1        This routine returns the V,I,OVP,... settings for the specified step of the presently selected sequence.

SCPI: PROGram:SELected:Define? <step #>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      ?    Thic control contains the step number. Valid range is 1 - 20.    >         Instrument Handle                  6      Status                                   Settings                          h I        Step                                   	           	            1    W    This routine deletes the selected sequence.

SCPI: PROGram:SELected:DELected:SELected         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.              Instrument Handle                 ƫ 6      Status                                 	           J    This routine deletes all sequences.

SCPI: PROGram:SELected:DELected:ALL         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.              Instrument Handle                 ȡ 6      Status                                 	               This routine programs and executes a VIMODE step immediately. The output will be programmed to the specified values.

SCPI: PROGram:SELected:EXECute <VIMODE> <voltage> <current> <ovp>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      3    This control contains the output voltage setting.     3    This control contains the output current setting.     <    This control contains the Over Voltage Protection setting.    ^         Instrument Handle                  h      Status                            ˈ i        Voltage                            i        Current                            ik       OVP                                    	           0    0    0   2    This routine programs and immediately executes a Voltage Ramp at the defined Voltage, Current, and OVP values for the specified time. The voltage will ramp from the present voltage setting to the value programmed in the voltage control.

SCPI: PROGram:SELected:EXECute <RAMPTOV> <voltage> <current> <ovp>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      :    This control contains the ending output voltage setting.     3    This control contains the output current setting.     <    This control contains the Over Voltage Protection setting.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.    Τ 2        Instrument Handle                 L '      Status                             h 2       Voltage                            h        Current                           K h       OVP                               Џ  2       Time                                   	           0    0    0    0   m    This routine programs and executes a Current Ramp at the defined Voltage, Current, and OVP values for the specified time. The current will ramp from the present current setting to the value programmed in the current control. An appropriate load is required for current mode operation.

SCPI: PROGram:SELected:EXECute <RAMPTOC> <voltage> <current> <ovp> <duration>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      3    This control contains the output voltage setting.     :    This control contains the ending output current setting.     <    This control contains the Over Voltage Protection setting.     \    This control specifies the length of the step in seconds. Valid range is 0.001sec - 99sec.     2        Instrument Handle                 r }      Status                             h 2       Voltage                           / h        Current                           q h       OVP                               յ  2       Time                                   	           0    0    0    0   v    This routine programs and immediately executes Constant Power Mode at the defined Power, Voltage, Current, and OVP values. If the specified power setting can not be realized then the power supply output will be limited to the voltage or current setting. These conditions are load dependent.

SCPI: PROGram:SELected:EXECute <POWERSETTINGS> <power> <voltage> <current> <ovp>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      <    This control contains the Maximum output voltage setting.      ;    This control contains the Maximum output current setting.     <    This control contains the Over Voltage Protection setting.     2    This control contains the output poower setting.     2        Instrument Handle                 ١ }      Status                            #  2       Voltage                           g         Current                           ڪ        OVP                                X 3       Power                                  	           0    0    0    0    j    This function allocates memory for a newly named sequence.

SCPI: PROGram:SELected:MALLocate <DEFAULT>

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G      Status                            ~  *        Instrument Handle                  	                   This function selects an already defined sequence for use or creates a new sequence if the name does not exist.

SCPI: PROGram:SELected:NAME <seq. name>

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     *    This control contains the Sequence Name.    ; G      Status                            ߽  *        Instrument Handle                 \ y *       Name                               	               0        This function selects an already defined sequence for use or creates a new sequence if the name does not exist.  A number after the name indicates which channel to use.

SCPI: PROGram:SELected:NAME <seq. name>

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     *    This control contains the Sequence Name.     +    This control contains the channel number.     G      Status                              *        Instrument Handle                 @ y *       Name                              r vI         Chan                               	               0    0        This function returns the name of the active sequence. If no sequence have been defined then a default name is returned.

SCPI: PROGram:SELected:NAME?
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     3    Control contains the name of the active sequence.    4 G      Status                              *        Instrument Handle                 U e (       Name                               	               	            Q    This routine saves the selected sequence.

SCPI: PROGram:SELected:SAVe:SELected         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.              Instrument Handle                 L 6      Status                                 	           D    This routine saves all sequences.

SCPI: PROGram:SELected:SAVe:ALL         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.              Instrument Handle                 < 6      Status                                 	          9    This function sets the sequence state to the specified value.
Valid states are:

0 = Run
1 = Pause
2 = Stop
3 = Resume
4 = Complete

Note: Complete should be issued to terminate an editing session. This would be used to save a sequence prior to defining another sequence.

SCPI: PROGram:SELected:STATe <state>

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     +    This control contains the sequence state.    y G      Status                              *        Instrument Handle                  ^ ,       State                              	               0        This function returns the sequence state.

Valid states are:

0 = Run
1 = Pause
2 = Stop
3 = Resume
4 = Complete

SCPI: PROGram:SELected:STATe?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     +    This control contains the sequence state.     G      Status                              *        Instrument Handle                 = [ '       State                              	               	            {    This routine gives a means for the users GPIB system computer to know when a sequence has completed.

SCPI: PROGram:WAIT?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      %        Instrument Handle                 V 6      Status                                 	               This routine triggers the selected sequence than has been priviously armed.

SCPI: TRIGger:SEQuence

NOTE:   Currently not used         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.       F        Instrument Handle                  	      Status                                 	               This function sends a software trigger. The trigger types are as follows:

1 = Voltage
2 = Current
3 = Both Voltage and Current
4 = Voltage or Current Ramp

SCPI: TRIGGER[]:TYPE <value>
      TRIGGER[]:RAMP         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.    W  8        Instrument Handle                  <      Status                           N>       Trigger Type                       0    	           1    f    This function clears all previously configured voltage and current triggers.

SCPI: TRIGGER[]:ABORT          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.       '        Instrument Handle                 K        Status                             0    	               This function reads the status byte from the instrument and creates a string that indicates which bits are active.

SCPI: *STB[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     X         Status Byte                       +  n  ,    Status Message                     (      Status                            [  5        Instrument Handle                  	            	            	                   This function reads the standard event status register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESR[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G         Standard Event Status Register      t  ,    Status Message                     >      Status                              5        Instrument Handle                  	            	            	                   This function reads the event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESE[]?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   G         Standard Event  Enable Register   t  ,    Status Message                   U >      Status                             5        Instrument Handle                  	            	            	                   This function reads the protection event status reister from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:EVENT?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   W         Protection Event Register           ,    Status Message                   &g      Status                            +        Instrument Handle                  	            	            	                   This function reads the protection event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:ENABLE?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   _         Prot. Event Enable Register         ,    Status Message                    g      Status                            +        Instrument Handle                  	            	            	                  This function reads the protection condition status reister from the instrument and creates a string that indicates which bits are active. Use this routine to determine the operating mode (voltage or current) of the power supply.

SCPI: STATUS[]:PROTECTION:CONDITION?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   P         Protection Condition Register     ~  ,    Status Message                   4g      Status                            +        Instrument Handle                  	            	            	                   This function reads the service request enable reister from the instrument and creates a string that indicates which bits are active.

SCPI:*SRE[]?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   L         Service Req. Enable Register      ~  ,    Status Message                   
g      Status                           r +        Instrument Handle                  	            	            	                   This function resets the instrument to its Power On state and clears all error and status reporting data structures.

SCPI: *RST[]
      *CLS[]

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    G      Status                           *  *        Instrument Handle                  	               V    This function clears all error and status reporting data structures.

SCPI: *CLS[]

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    G      Status                           #  *        Instrument Handle                  	               l    This function reads an error code and error string from the instrument's error queue.

SCPI: SYSTEM:ERROR?     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    = D   `    Error Code                        ?   ,    Error Message                     ?      Status                           6  6        Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     (    Reports the status of this operation.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   d r    `    Status Code                        0      Message                          
      Status                            5        Instrument Handle                  0    	            	           VI_NULL    ~    This function returns the Manufacturer, Model, Serial Number and firmware revision numbers of the instrument.

SCPI: *IDN[]?         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    S        *IDN? Respone                    f       Status                             1        Instrument Handle                  	            	               ^    This function returns the revision numbers of the instrument driver and instrument firmware.         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    C        Instrument Driver Revision       6         Firmware Revision                 ]      Status                            ?  3        Instrument Handle                  	            	            	                   This function recalls the instrument's maximum voltage and current rating.

SCPI: CALIBRATE[]:MODEL:VOLTAGE?
      CALIBRATE[]:MODEL:CURRENT?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.    "q  	        Instrument Handle                #        Status                           ? 
       Model Voltage                    ?        Model Current                          	           	           	               This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   %D pD      Status                           % r `        Instrument Handle                  	                     
b               K.        init                                                                                                                                             I  u             K.        GenerateDCVolt                                                                                                                                   +  Z             K.        GenerateDCCurr                                                                                                                                      ";             K.        GeneratePower                                                                                                                                    "  &             .        GenerateDCVRamp                                                                                                                                  '  *8             .        GenerateDCCRamp                                                                                                                                  +*  -+             K.        OutState                                                                                                                                         -  /             .        MeasureDCVolt                                                                                                                                    0\  2             .        MeasureDCCurr                                                                                                                                    2  4             .        MeasurePower                                                                                                                                     5H  7W             K.        ModeQuery                                                                                                                                        8  :             K.        VoltMode                                                                                                                                         ;  >5             K.        CurrMode                                                                                                                                         >  A             K.        NormalMode                                                                                                                                       A~  C             K.        ConfigDCVolt                                                                                                                                     D  G             K.        ConfigDCCurr                                                                                                                                     G  J             K.        ConfigDCVRamp                                                                                                                                    K  N             K.        ConfigDCCRamp                                                                                                                                    O  R`             K.        ConfigOVP                                                                                                                                        S  T             K.        ConfigSoftLimits                                                                                                                                 U  X             K.        ConfigPowerOn                                                                                                                                    Y:  [o             K.        ConfigFoldback                                                                                                                                   \#  ^I             K.        ConfigProtDelay                                                                                                                                  ^  a\             K.        ConfigVoltAve                                                                                                                                    b  do             K.        ConfigCurrAve                                                                                                                                    e#  g             K.        ConfigProtEventEnable                                                                                                                            hk  jj             K.        ConfigStandEventEnable                                                                                                                           k  m             K.        ConfigSerReqEnable                                                                                                                               nr  p%             .        OutputVoltQuery                                                                                                                                  p  r             .        OutputCurrQuery                                                                                                                                  sS  u             .        OutputPowerQuery                                                                                                                                 u  w             .        OutputOVPQuery                                                                                                                                   xR  y             K.        OutStateQuery                                                                                                                                    zy  |0             .        SoftLimitsQuery                                                                                                                                  },                .        PowerOnQuery                                                                                                                                     ]               .        protDelayQuery                                                                                                                                                  .        measVoltAveQuery                                                                                                                                                .        measCurrAveQuery                                                                                                                                 _               K.        SeqInit                                                                                                                                          b  w             K.        SeqCatalog                                                                                                                                       2               K.        SeqArm                                                                                                                                           a  H             K.        ProgVIMode                                                                                                                                                      K.        ProgVoltRamp                                                                                                                                                    K.        ProgCurrRamp                                                                                                                                     d  
             K.        ProgPowerMode                                                                                                                                                   K.        ProgRepeat                                                                                                                                                      K.        ProgCall                                                                                                                                           (             K.        ProgReturn                                                                                                                                                      K.        ProgLoop                                                                                                                                         |  o             K.        ProgNext                                                                                                                                         #               K.        ProgStop                                                                                                                                           $             K.        ProgGoto                                                                                                                                           7             K.        ProgPause                                                                                                                                                       K.        ProgNOP                                                                                                                                          £  į             K.        ProgDefineQuery                                                                                                                                  Ť  -             K.        ProgDeleteSelected                                                                                                                               ǧ  #             K.        ProgDeleteAll                                                                                                                                    ɝ  B             K.        ImmExeVI                                                                                                                                         j               K.        ImmExeVoltRamp                                                                                                                                   U               K.        ImmExeCurrRamp                                                                                                                                   {  (             K.        ImmExePowerMode                                                                                                                                  ܊               K.        ProgMemAlloc                                                                                                                                     ޗ               K.        ProgName                                                                                                                                         B               K.        ProgNameChan                                                                                                                                                    K.        ProgNameQuery                                                                                                                                    K               K.        ProgSaveSelected                                                                                                                                 H               K.        ProgSaveAll                                                                                                                                      8               K.        ProgState                                                                                                                                          p             K.        ProgStateQuery                                                                                                                                   +               K.        SeqWait                                                                                                                                          R               K.        SeqTrig                                                                                                                                                         K.        SendSWTrigger                                                                                                                                    5               K.        AbortTrigger                                                                                                                                     H               K.        StatusByteQuery                                                                                                                                                 K.        StandEventQuery                                                                                                                                  v             K.        StandEventEnableQuery                                                                                                                           r G             K.        ProtEventQuery                                                                                                                                  C 	!             K.        ProtEventEnableQuery                                                                                                                            
 U             K.        ProtCondQuery                                                                                                                                   
Q              K.        ServiceReqEnableQuery                                                                                                                           
              K.        reset                                                                                                                                           C              K.        clear                                                                                                                                           <              K.        errorQuery                                                                                                                                       V             K.        errorMessage                                                                                                                                    R              K.        idQuery                                                                                                                                         B               E.        revisionQuery                                                                                                                                   ! #             .        ModelQuery                                                                                                                                      $ &e             K.        close                                                                                                                                                                                                                               Initialize                                                                          Application Functions                                                             Generate Output                                                                      Generate DC Voltage                                                                  Generate DC Current                                                                  Generate Power                                                                       Generate DC Voltage Ramp                                                             Generate DC Current Ramp                                                            Output State                                                                         Output State On/Off                                                               Measure Output                                                                       Measure DC Voltage                                                                   Measure DC Current                                                                   Measure Power                                                                     Operating Mode                                                                       Query Output Mode                                                                    Constant Voltage Mode                                                                Constant Current Mode                                                                Normal Mode                                                                         Configuration Functions                                                              Configure DC Voltage                                                                 Configure DC Current                                                                 Configure DC Voltage Ramp                                                            Configure DC Current Ramp                                                            Configure OVP                                                                        Configure Soft Limits                                                                Configure Power On                                                                   Configure Foldback                                                                   Configure Protection Delay                                                           Configure Voltage Measurement Average                                                Configure Current Measurement Average                                                Configure Protect. Event Enable                                                      Configure Standard Event Enable                                                      Configure Service Req. Enable                                                        Output Voltage Query                                                                 Output Current Query                                                                 Output Power Query                                                                   Output OVP Query                                                                     Output State Query                                                                   Soft Limits Query                                                                    Power On Query                                                                       Protection Delay Query                                                               Voltage Measurement Average Query                                                    Current Measurement Average Query                                                   xSequence/Program                                                                     Program Initialize                                                                   Sequence Catalog Query                                                               Sequence Arm                                                                         Program VI Mode                                                                      Program Voltage Ramp                                                                 Program Current Ramp                                                                 Program Constant Power Mode                                                          Program Repeat                                                                       Program Call                                                                         Program Return                                                                       Program Loop                                                                         Program Next                                                                         Program Stop                                                                         Program Goto                                                                         Program Pause                                                                        Program NOP                                                                          Program Define Query                                                                 Program Delete Selected                                                              Program Delete All                                                                   Immediate Execute VIMode                                                             Immediate Execute Voltage Ramp                                                       Immediate Execute Current Ramp                                                       Immediate Execute Constant Power Mode                                                Program Memory Allocation                                                            Program Name                                                                         Program Name & Channel                                                               Program Name Query                                                                   Program Save Selected                                                                Program Save All                                                                     Program State                                                                        Program State Query                                                                  Program Wait                                                                         Program Trigger                                                                     	Action/Status Functions                                                              Send Software Trigger                                                                Abort Trigger                                                                        Status Byte Query                                                                    Standard Event Query                                                                 Standard Event Enable Query                                                          Protection Event Query                                                               Protection Event Enable Query                                                        Protection Condition Query                                                           Sevice Req. Enable Query                                                            
Utility Functions                                                                    Reset                                                                                Clear                                                                                Error Query                                                                          Error Message                                                                        Id Query                                                                             Revision Query                                                                       Model Query                                                                          Close                                                                           